
#ifndef _HORIZON_H_
#define _HORIZON_H_

/**
 * @short Application Main Window
 * @author FF <fred@wei>
 * @version 0.1
 */

/*

This class represents the whole application, and (mainly) provides entry points to enter & exit the application.
You need an application class for your whole application.

*/

class 
horizonapp : public wxApp
{
	public:
		virtual bool OnInit();
};

class ArtificialHorizon : public wxWindow
{
	protected :
		void draw(wxDC&);
		void transform(int,int,int&,int&,int trans_y=1);	

	public :
		double angle,height;
		int cx,cy,radius;

		ArtificialHorizon(wxWindow *parent, const wxPoint& pos, const wxSize& size);
		virtual ~ArtificialHorizon() { }

		void OnPaint(wxPaintEvent&);
	    	void OnKey(wxKeyEvent&);

		DECLARE_EVENT_TABLE()
};	

/*

A Frame (ie something deriving from wxFrame) represents a window. This class thus represents our window.

An instance of this class is created (see the .c file) by our application.
Because this is our main window, we will also create a menubar with the traditional menus.

*/


class 
horizonFrame : public wxFrame
{
	public:
		horizonFrame( const wxString& title, const wxPoint& pos, const wxSize& size );
		void OnQuit( wxCommandEvent& event );
		void OnAbout( wxCommandEvent& event );

	protected:
		ArtificialHorizon *horizon;

	private:
		DECLARE_EVENT_TABLE()
};

enum
{
	Menu_File_Quit = 100,
	Menu_File_About
};

#endif // _HORIZON_H_
